using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Text;
using System.Globalization;
using System.Diagnostics;
using System.Threading;

using nsAlienRFID2;

namespace Ex11
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form11 : System.Windows.Forms.Form
	{
		internal delegate void displayMessageDlgt(string msg);

		enum eReaderType
		{
			x780,
			x800,
			x900
		}

		eReaderType meReaderType = eReaderType.x900;

		private clsReader mReader;
		private ReaderInfo mReaderInfo;
		private ComInterface meReaderInterface = ComInterface.enumTCPIP;
		private bool mbDisposing = false;
		private decimal mSavedNUDvalue = 0;
		private string msLastTagID = null;

		private const string G2MASK = "'bank#' as deximal, 'bitPtr' as decimal, 'bitLen' as decimal, 'bytes' as hexadecimal";
		private const string C1MASK = "'bitPtr' as decimal, 'bitLen' as decimal, 'bytes' as hexadecimal";

		#region "ALR-x780 readers support only these programming commands"
		private string[] mOldCommands = new string[] { 
			"Program Tag", 
			"Erase Tag", 
			"Lock Tag", 
			"Kill Tag",
			"ProgIncrementOnFail",
			"ProgramPassCode",
			"ProgramID",
			"ProgAttempts",
			"ProgEraseAttempts",
			"ProgReadAttempts",
			"ProgSuccessFormat"
		};
		#endregion

		#region "List of programming commands supported by ALR-x800, -9900 readers"
		private string[] mNewCommands = new string[] {
			"ProgramEPC",
			"ProgramAndLockEPC",
			"ProgramUser",
			"ProgramAndLockUser",
			"ProgramKillPwd",
			"ProgramAccessPwd",
			"ProgEPCData",
			"ProgEPCDataInc",
			"ProgC1KillPwd",
			"ProgG2KillPwd",
			"ProgG2AccessPwd",
			"AcqG2AccessPwd",
			"ProgUserData",
			"ProgUserDataInc",
			"ProgG2LockType",
			"Lock",
			"Unlock", 
			"G2Write",
			"ProgramAlienImage",
			"ProgAlienImageMap",
			"ProgAlienImageNSI"
		};
		#endregion



		#region "Auto Generated Code"

		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.GroupBox grpConnection;
		private System.Windows.Forms.RadioButton rdoSerial;
		private System.Windows.Forms.RadioButton rdoTCP;
		private System.Windows.Forms.GroupBox grpSerial;
		private System.Windows.Forms.ComboBox cboHostBaudRate;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.ComboBox cboPorts;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.GroupBox grpNetwork;
		private System.Windows.Forms.CheckBox chkKeepConnectionAlive;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.NumericUpDown PortUD;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Button btnDisconnect;
		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label lblStatus;
		private System.Windows.Forms.GroupBox grpProgramAntenna;
		private System.Windows.Forms.GroupBox grpProgramProtocol;
		private System.Windows.Forms.RadioButton rdoClass0;
		private System.Windows.Forms.TrackBar trackBar1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.ComboBox cboProgramCommands;
		private System.Windows.Forms.ComboBox cboProgramOptions;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.RadioButton rdoAntenna3;
		private System.Windows.Forms.RadioButton rdoAntenna2;
		private System.Windows.Forms.RadioButton rdoAntenna1;
		private System.Windows.Forms.RadioButton rdoAntenna0;
		private System.Windows.Forms.TextBox txtAntennaPower;
		private System.Windows.Forms.RadioButton rdoGen2;
		private System.Windows.Forms.RadioButton rdoClass1;
		private System.Windows.Forms.NumericUpDown nudEnterWakes;
		private System.Windows.Forms.NumericUpDown nudExitWakes;
		private System.Windows.Forms.NumericUpDown nudQ;
		private System.Windows.Forms.NumericUpDown nudSession;
		private System.Windows.Forms.NumericUpDown nudCycles;
		private System.Windows.Forms.NumericUpDown nudCount;
		private System.Windows.Forms.NumericUpDown nudSleeps;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.TextBox txtMask;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.Label lblCurrentTag;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.GroupBox grpReading;
		private System.Windows.Forms.GroupBox grpProgramming;
		private System.Windows.Forms.Button btnSend;
		private System.Windows.Forms.Label lblCurrentTagStatus;
		private System.Windows.Forms.TextBox txtProgramData;
		private System.Windows.Forms.TextBox txtIPAddress;
		private System.Windows.Forms.Button btnG2Read;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.Label lblG2ReadResponse;
		private System.Windows.Forms.ComboBox cboG2Bank;
		private System.Windows.Forms.NumericUpDown nudWordPtr;
		private System.Windows.Forms.NumericUpDown nudWordLen;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label21;
		private System.Windows.Forms.Label label23;
		private System.Windows.Forms.GroupBox grpWriteParms;
		private System.Windows.Forms.NumericUpDown nudWordPtr2;
		private System.Windows.Forms.Label lblTagReadStatus;
		private System.Windows.Forms.GroupBox grpG2Reading;
		private System.ComponentModel.IContainer components;

		public Form11()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			mbDisposing = true;
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.txtProgramData = new System.Windows.Forms.TextBox();
            this.errorProvider1 = new System.Windows.Forms.ErrorProvider(this.components);
            this.grpConnection = new System.Windows.Forms.GroupBox();
            this.rdoSerial = new System.Windows.Forms.RadioButton();
            this.rdoTCP = new System.Windows.Forms.RadioButton();
            this.grpSerial = new System.Windows.Forms.GroupBox();
            this.cboHostBaudRate = new System.Windows.Forms.ComboBox();
            this.label4 = new System.Windows.Forms.Label();
            this.cboPorts = new System.Windows.Forms.ComboBox();
            this.label5 = new System.Windows.Forms.Label();
            this.grpNetwork = new System.Windows.Forms.GroupBox();
            this.chkKeepConnectionAlive = new System.Windows.Forms.CheckBox();
            this.txtIPAddress = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.PortUD = new System.Windows.Forms.NumericUpDown();
            this.label6 = new System.Windows.Forms.Label();
            this.btnDisconnect = new System.Windows.Forms.Button();
            this.btnConnect = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.lblStatus = new System.Windows.Forms.Label();
            this.grpProgramAntenna = new System.Windows.Forms.GroupBox();
            this.rdoAntenna3 = new System.Windows.Forms.RadioButton();
            this.rdoAntenna2 = new System.Windows.Forms.RadioButton();
            this.rdoAntenna1 = new System.Windows.Forms.RadioButton();
            this.rdoAntenna0 = new System.Windows.Forms.RadioButton();
            this.txtAntennaPower = new System.Windows.Forms.TextBox();
            this.label13 = new System.Windows.Forms.Label();
            this.trackBar1 = new System.Windows.Forms.TrackBar();
            this.grpProgramProtocol = new System.Windows.Forms.GroupBox();
            this.rdoGen2 = new System.Windows.Forms.RadioButton();
            this.rdoClass1 = new System.Windows.Forms.RadioButton();
            this.rdoClass0 = new System.Windows.Forms.RadioButton();
            this.grpReading = new System.Windows.Forms.GroupBox();
            this.grpG2Reading = new System.Windows.Forms.GroupBox();
            this.btnG2Read = new System.Windows.Forms.Button();
            this.label19 = new System.Windows.Forms.Label();
            this.label20 = new System.Windows.Forms.Label();
            this.nudWordPtr = new System.Windows.Forms.NumericUpDown();
            this.lblG2ReadResponse = new System.Windows.Forms.Label();
            this.cboG2Bank = new System.Windows.Forms.ComboBox();
            this.nudWordLen = new System.Windows.Forms.NumericUpDown();
            this.label16 = new System.Windows.Forms.Label();
            this.label21 = new System.Windows.Forms.Label();
            this.lblCurrentTag = new System.Windows.Forms.Label();
            this.nudEnterWakes = new System.Windows.Forms.NumericUpDown();
            this.label8 = new System.Windows.Forms.Label();
            this.nudExitWakes = new System.Windows.Forms.NumericUpDown();
            this.nudQ = new System.Windows.Forms.NumericUpDown();
            this.label15 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.nudSession = new System.Windows.Forms.NumericUpDown();
            this.nudCycles = new System.Windows.Forms.NumericUpDown();
            this.nudCount = new System.Windows.Forms.NumericUpDown();
            this.label10 = new System.Windows.Forms.Label();
            this.label12 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.nudSleeps = new System.Windows.Forms.NumericUpDown();
            this.label14 = new System.Windows.Forms.Label();
            this.label17 = new System.Windows.Forms.Label();
            this.label18 = new System.Windows.Forms.Label();
            this.txtMask = new System.Windows.Forms.TextBox();
            this.lblTagReadStatus = new System.Windows.Forms.Label();
            this.lblCurrentTagStatus = new System.Windows.Forms.Label();
            this.grpProgramming = new System.Windows.Forms.GroupBox();
            this.cboProgramCommands = new System.Windows.Forms.ComboBox();
            this.btnSend = new System.Windows.Forms.Button();
            this.cboProgramOptions = new System.Windows.Forms.ComboBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label7 = new System.Windows.Forms.Label();
            this.grpWriteParms = new System.Windows.Forms.GroupBox();
            this.label23 = new System.Windows.Forms.Label();
            this.nudWordPtr2 = new System.Windows.Forms.NumericUpDown();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).BeginInit();
            this.grpConnection.SuspendLayout();
            this.grpSerial.SuspendLayout();
            this.grpNetwork.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).BeginInit();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.grpProgramAntenna.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar1)).BeginInit();
            this.grpProgramProtocol.SuspendLayout();
            this.grpReading.SuspendLayout();
            this.grpG2Reading.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.nudWordPtr)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudWordLen)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudEnterWakes)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudExitWakes)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudQ)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudSession)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudCycles)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudCount)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudSleeps)).BeginInit();
            this.grpProgramming.SuspendLayout();
            this.grpWriteParms.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.nudWordPtr2)).BeginInit();
            this.SuspendLayout();
            // 
            // txtProgramData
            // 
            this.txtProgramData.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtProgramData.Location = new System.Drawing.Point(544, 112);
            this.txtProgramData.MaxLength = 256;
            this.txtProgramData.Name = "txtProgramData";
            this.txtProgramData.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtProgramData.Size = new System.Drawing.Size(344, 21);
            this.txtProgramData.TabIndex = 8;
            this.txtProgramData.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // errorProvider1
            // 
            this.errorProvider1.ContainerControl = this;
            // 
            // grpConnection
            // 
            this.grpConnection.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpConnection.Controls.Add(this.rdoSerial);
            this.grpConnection.Controls.Add(this.rdoTCP);
            this.grpConnection.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpConnection.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpConnection.Location = new System.Drawing.Point(324, 24);
            this.grpConnection.Name = "grpConnection";
            this.grpConnection.Size = new System.Drawing.Size(264, 48);
            this.grpConnection.TabIndex = 34;
            this.grpConnection.TabStop = false;
            // 
            // rdoSerial
            // 
            this.rdoSerial.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoSerial.Location = new System.Drawing.Point(176, 16);
            this.rdoSerial.Name = "rdoSerial";
            this.rdoSerial.Size = new System.Drawing.Size(56, 21);
            this.rdoSerial.TabIndex = 1;
            this.rdoSerial.Text = "Seria&l";
            this.rdoSerial.UseVisualStyleBackColor = false;
            this.rdoSerial.CheckedChanged += new System.EventHandler(this.rdoSerial_CheckedChanged);
            // 
            // rdoTCP
            // 
            this.rdoTCP.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoTCP.Checked = true;
            this.rdoTCP.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoTCP.Location = new System.Drawing.Point(64, 16);
            this.rdoTCP.Name = "rdoTCP";
            this.rdoTCP.Size = new System.Drawing.Size(46, 21);
            this.rdoTCP.TabIndex = 0;
            this.rdoTCP.TabStop = true;
            this.rdoTCP.Text = "TC&P";
            this.rdoTCP.UseVisualStyleBackColor = false;
            this.rdoTCP.CheckedChanged += new System.EventHandler(this.rdoTCP_CheckedChanged);
            // 
            // grpSerial
            // 
            this.grpSerial.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpSerial.Controls.Add(this.cboHostBaudRate);
            this.grpSerial.Controls.Add(this.label4);
            this.grpSerial.Controls.Add(this.cboPorts);
            this.grpSerial.Controls.Add(this.label5);
            this.grpSerial.Enabled = false;
            this.grpSerial.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpSerial.Location = new System.Drawing.Point(600, 24);
            this.grpSerial.Name = "grpSerial";
            this.grpSerial.Size = new System.Drawing.Size(296, 72);
            this.grpSerial.TabIndex = 33;
            this.grpSerial.TabStop = false;
            this.grpSerial.Text = "Com Port";
            // 
            // cboHostBaudRate
            // 
            this.cboHostBaudRate.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboHostBaudRate.Items.AddRange(new object[] {
            "115200",
            "57600",
            "38400",
            "19200",
            "9600"});
            this.cboHostBaudRate.Location = new System.Drawing.Point(120, 40);
            this.cboHostBaudRate.Name = "cboHostBaudRate";
            this.cboHostBaudRate.Size = new System.Drawing.Size(96, 20);
            this.cboHostBaudRate.TabIndex = 17;
            this.cboHostBaudRate.SelectedIndexChanged += new System.EventHandler(this.cboHostBaudRate_SelectedIndexChanged);
            // 
            // label4
            // 
            this.label4.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label4.Location = new System.Drawing.Point(24, 48);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(88, 16);
            this.label4.TabIndex = 18;
            this.label4.Text = "Host Baud Rate:";
            this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // cboPorts
            // 
            this.cboPorts.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboPorts.Items.AddRange(new object[] {
            "COM1:",
            "COM2:",
            "COM3:",
            "COM4:",
            "COM5:",
            "COM6:",
            "COM7:",
            "COM8:",
            "COM9:"});
            this.cboPorts.Location = new System.Drawing.Point(120, 16);
            this.cboPorts.Name = "cboPorts";
            this.cboPorts.Size = new System.Drawing.Size(96, 20);
            this.cboPorts.TabIndex = 13;
            this.cboPorts.SelectedIndexChanged += new System.EventHandler(this.cboPorts_SelectedIndexChanged);
            // 
            // label5
            // 
            this.label5.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label5.Location = new System.Drawing.Point(48, 24);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(64, 20);
            this.label5.TabIndex = 14;
            this.label5.Text = "Port Name:";
            this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // grpNetwork
            // 
            this.grpNetwork.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpNetwork.Controls.Add(this.chkKeepConnectionAlive);
            this.grpNetwork.Controls.Add(this.txtIPAddress);
            this.grpNetwork.Controls.Add(this.label2);
            this.grpNetwork.Controls.Add(this.PortUD);
            this.grpNetwork.Controls.Add(this.label6);
            this.grpNetwork.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpNetwork.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpNetwork.Location = new System.Drawing.Point(24, 24);
            this.grpNetwork.Name = "grpNetwork";
            this.grpNetwork.Size = new System.Drawing.Size(290, 72);
            this.grpNetwork.TabIndex = 32;
            this.grpNetwork.TabStop = false;
            this.grpNetwork.Text = "Network Settings";
            // 
            // chkKeepConnectionAlive
            // 
            this.chkKeepConnectionAlive.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.chkKeepConnectionAlive.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.chkKeepConnectionAlive.Location = new System.Drawing.Point(200, 16);
            this.chkKeepConnectionAlive.Name = "chkKeepConnectionAlive";
            this.chkKeepConnectionAlive.Size = new System.Drawing.Size(72, 40);
            this.chkKeepConnectionAlive.TabIndex = 10;
            this.chkKeepConnectionAlive.Text = "Keep Connection Alive: ";
            this.chkKeepConnectionAlive.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.chkKeepConnectionAlive.CheckedChanged += new System.EventHandler(this.chkKeepConnectionAlive_CheckedChanged);
            // 
            // txtIPAddress
            // 
            this.txtIPAddress.Location = new System.Drawing.Point(88, 16);
            this.txtIPAddress.Name = "txtIPAddress";
            this.txtIPAddress.Size = new System.Drawing.Size(88, 18);
            this.txtIPAddress.TabIndex = 1;
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(24, 16);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(48, 20);
            this.label2.TabIndex = 9;
            this.label2.Text = " Reader\'s IP Address:";
            this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // PortUD
            // 
            this.PortUD.Location = new System.Drawing.Point(96, 40);
            this.PortUD.Name = "PortUD";
            this.PortUD.Size = new System.Drawing.Size(72, 18);
            this.PortUD.TabIndex = 8;
            this.PortUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.PortUD.Value = new decimal(new int[] {
            23,
            0,
            0,
            0});
            this.PortUD.ValueChanged += new System.EventHandler(this.PortUD_ValueChanged);
            // 
            // label6
            // 
            this.label6.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label6.Location = new System.Drawing.Point(16, 40);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(67, 20);
            this.label6.TabIndex = 6;
            this.label6.Text = "Telnet Port:";
            this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // btnDisconnect
            // 
            this.btnDisconnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnDisconnect.Enabled = false;
            this.btnDisconnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnDisconnect.Location = new System.Drawing.Point(480, 80);
            this.btnDisconnect.Name = "btnDisconnect";
            this.btnDisconnect.Size = new System.Drawing.Size(88, 32);
            this.btnDisconnect.TabIndex = 38;
            this.btnDisconnect.Text = "&Disconnect";
            this.btnDisconnect.UseVisualStyleBackColor = false;
            this.btnDisconnect.Click += new System.EventHandler(this.btnDisconnect_Click);
            // 
            // btnConnect
            // 
            this.btnConnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnConnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnConnect.Location = new System.Drawing.Point(344, 80);
            this.btnConnect.Name = "btnConnect";
            this.btnConnect.Size = new System.Drawing.Size(88, 32);
            this.btnConnect.TabIndex = 37;
            this.btnConnect.Text = "&Connect + Login";
            this.btnConnect.UseVisualStyleBackColor = false;
            this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = System.Windows.Forms.AnchorStyles.Top;
            this.groupBox1.Controls.Add(this.grpConnection);
            this.groupBox1.Controls.Add(this.grpSerial);
            this.groupBox1.Controls.Add(this.btnDisconnect);
            this.groupBox1.Controls.Add(this.btnConnect);
            this.groupBox1.Controls.Add(this.grpNetwork);
            this.groupBox1.Location = new System.Drawing.Point(8, 8);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(912, 120);
            this.groupBox1.TabIndex = 39;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Reader Connection: ";
            // 
            // groupBox2
            // 
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.BackColor = System.Drawing.SystemColors.ControlText;
            this.groupBox2.Controls.Add(this.lblStatus);
            this.groupBox2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupBox2.Location = new System.Drawing.Point(8, 520);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(912, 48);
            this.groupBox2.TabIndex = 41;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Status:";
            // 
            // lblStatus
            // 
            this.lblStatus.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lblStatus.Location = new System.Drawing.Point(48, 18);
            this.lblStatus.Name = "lblStatus";
            this.lblStatus.Size = new System.Drawing.Size(840, 20);
            this.lblStatus.TabIndex = 7;
            this.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // grpProgramAntenna
            // 
            this.grpProgramAntenna.Controls.Add(this.rdoAntenna3);
            this.grpProgramAntenna.Controls.Add(this.rdoAntenna2);
            this.grpProgramAntenna.Controls.Add(this.rdoAntenna1);
            this.grpProgramAntenna.Controls.Add(this.rdoAntenna0);
            this.grpProgramAntenna.Controls.Add(this.txtAntennaPower);
            this.grpProgramAntenna.Controls.Add(this.label13);
            this.grpProgramAntenna.Controls.Add(this.trackBar1);
            this.grpProgramAntenna.Location = new System.Drawing.Point(16, 24);
            this.grpProgramAntenna.Name = "grpProgramAntenna";
            this.grpProgramAntenna.Size = new System.Drawing.Size(432, 64);
            this.grpProgramAntenna.TabIndex = 44;
            this.grpProgramAntenna.TabStop = false;
            this.grpProgramAntenna.Text = "Prog. Antenna";
            // 
            // rdoAntenna3
            // 
            this.rdoAntenna3.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoAntenna3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoAntenna3.Location = new System.Drawing.Point(224, 32);
            this.rdoAntenna3.Name = "rdoAntenna3";
            this.rdoAntenna3.Size = new System.Drawing.Size(39, 21);
            this.rdoAntenna3.TabIndex = 5;
            this.rdoAntenna3.Text = "&3";
            this.rdoAntenna3.UseVisualStyleBackColor = false;
            this.rdoAntenna3.Click += new System.EventHandler(this.rdoAntenna_Clicked);
            this.rdoAntenna3.CheckedChanged += new System.EventHandler(this.rdoAntenna_CheckedChanged);
            // 
            // rdoAntenna2
            // 
            this.rdoAntenna2.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoAntenna2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoAntenna2.Location = new System.Drawing.Point(152, 32);
            this.rdoAntenna2.Name = "rdoAntenna2";
            this.rdoAntenna2.Size = new System.Drawing.Size(40, 21);
            this.rdoAntenna2.TabIndex = 4;
            this.rdoAntenna2.Text = "&2";
            this.rdoAntenna2.UseVisualStyleBackColor = false;
            this.rdoAntenna2.Click += new System.EventHandler(this.rdoAntenna_Clicked);
            this.rdoAntenna2.CheckedChanged += new System.EventHandler(this.rdoAntenna_CheckedChanged);
            // 
            // rdoAntenna1
            // 
            this.rdoAntenna1.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoAntenna1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoAntenna1.Location = new System.Drawing.Point(88, 32);
            this.rdoAntenna1.Name = "rdoAntenna1";
            this.rdoAntenna1.Size = new System.Drawing.Size(40, 21);
            this.rdoAntenna1.TabIndex = 3;
            this.rdoAntenna1.Text = "&1";
            this.rdoAntenna1.UseVisualStyleBackColor = false;
            this.rdoAntenna1.Click += new System.EventHandler(this.rdoAntenna_Clicked);
            this.rdoAntenna1.CheckedChanged += new System.EventHandler(this.rdoAntenna_CheckedChanged);
            // 
            // rdoAntenna0
            // 
            this.rdoAntenna0.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoAntenna0.Checked = true;
            this.rdoAntenna0.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoAntenna0.Location = new System.Drawing.Point(24, 32);
            this.rdoAntenna0.Name = "rdoAntenna0";
            this.rdoAntenna0.Size = new System.Drawing.Size(40, 21);
            this.rdoAntenna0.TabIndex = 2;
            this.rdoAntenna0.TabStop = true;
            this.rdoAntenna0.Text = "&0";
            this.rdoAntenna0.UseVisualStyleBackColor = false;
            this.rdoAntenna0.Click += new System.EventHandler(this.rdoAntenna_Clicked);
            this.rdoAntenna0.CheckedChanged += new System.EventHandler(this.rdoAntenna_CheckedChanged);
            // 
            // txtAntennaPower
            // 
            this.txtAntennaPower.Location = new System.Drawing.Point(368, 35);
            this.txtAntennaPower.Name = "txtAntennaPower";
            this.txtAntennaPower.Size = new System.Drawing.Size(32, 20);
            this.txtAntennaPower.TabIndex = 47;
            this.txtAntennaPower.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.txtAntennaPower.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtAntennaPower_KeyUp);
            // 
            // label13
            // 
            this.label13.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label13.Location = new System.Drawing.Point(288, 40);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(80, 16);
            this.label13.TabIndex = 6;
            this.label13.Text = "RF Power (%): ";
            // 
            // trackBar1
            // 
            this.trackBar1.BackColor = System.Drawing.Color.Black;
            this.trackBar1.LargeChange = 30;
            this.trackBar1.Location = new System.Drawing.Point(280, 10);
            this.trackBar1.Maximum = 100;
            this.trackBar1.Minimum = 4;
            this.trackBar1.Name = "trackBar1";
            this.trackBar1.Size = new System.Drawing.Size(128, 42);
            this.trackBar1.TabIndex = 46;
            this.trackBar1.Value = 4;
            this.trackBar1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.trackBar1_MouseUp);
            // 
            // grpProgramProtocol
            // 
            this.grpProgramProtocol.Controls.Add(this.rdoGen2);
            this.grpProgramProtocol.Controls.Add(this.rdoClass1);
            this.grpProgramProtocol.Controls.Add(this.rdoClass0);
            this.grpProgramProtocol.Location = new System.Drawing.Point(464, 24);
            this.grpProgramProtocol.Name = "grpProgramProtocol";
            this.grpProgramProtocol.Size = new System.Drawing.Size(432, 64);
            this.grpProgramProtocol.TabIndex = 45;
            this.grpProgramProtocol.TabStop = false;
            this.grpProgramProtocol.Text = "Protocol";
            // 
            // rdoGen2
            // 
            this.rdoGen2.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoGen2.Checked = true;
            this.rdoGen2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoGen2.Location = new System.Drawing.Point(312, 29);
            this.rdoGen2.Name = "rdoGen2";
            this.rdoGen2.Size = new System.Drawing.Size(96, 16);
            this.rdoGen2.TabIndex = 4;
            this.rdoGen2.TabStop = true;
            this.rdoGen2.Text = "Class1 Gen&2";
            this.rdoGen2.UseVisualStyleBackColor = false;
            this.rdoGen2.Validating += new System.ComponentModel.CancelEventHandler(this.protocol_Validating);
            // 
            // rdoClass1
            // 
            this.rdoClass1.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoClass1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoClass1.Location = new System.Drawing.Point(184, 28);
            this.rdoClass1.Name = "rdoClass1";
            this.rdoClass1.Size = new System.Drawing.Size(64, 16);
            this.rdoClass1.TabIndex = 3;
            this.rdoClass1.Text = "Class&1";
            this.rdoClass1.UseVisualStyleBackColor = false;
            this.rdoClass1.Validating += new System.ComponentModel.CancelEventHandler(this.protocol_Validating);
            // 
            // rdoClass0
            // 
            this.rdoClass0.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoClass0.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoClass0.Location = new System.Drawing.Point(56, 29);
            this.rdoClass0.Name = "rdoClass0";
            this.rdoClass0.Size = new System.Drawing.Size(71, 16);
            this.rdoClass0.TabIndex = 2;
            this.rdoClass0.Text = "Class&0";
            this.rdoClass0.UseVisualStyleBackColor = false;
            // 
            // grpReading
            // 
            this.grpReading.Controls.Add(this.grpG2Reading);
            this.grpReading.Controls.Add(this.lblCurrentTag);
            this.grpReading.Controls.Add(this.nudEnterWakes);
            this.grpReading.Controls.Add(this.label8);
            this.grpReading.Controls.Add(this.nudExitWakes);
            this.grpReading.Controls.Add(this.nudQ);
            this.grpReading.Controls.Add(this.label15);
            this.grpReading.Controls.Add(this.label9);
            this.grpReading.Controls.Add(this.nudSession);
            this.grpReading.Controls.Add(this.nudCycles);
            this.grpReading.Controls.Add(this.nudCount);
            this.grpReading.Controls.Add(this.label10);
            this.grpReading.Controls.Add(this.label12);
            this.grpReading.Controls.Add(this.label11);
            this.grpReading.Controls.Add(this.nudSleeps);
            this.grpReading.Controls.Add(this.label14);
            this.grpReading.Controls.Add(this.label17);
            this.grpReading.Controls.Add(this.label18);
            this.grpReading.Controls.Add(this.txtMask);
            this.grpReading.Controls.Add(this.lblTagReadStatus);
            this.grpReading.Controls.Add(this.lblCurrentTagStatus);
            this.grpReading.Location = new System.Drawing.Point(8, 136);
            this.grpReading.Name = "grpReading";
            this.grpReading.Size = new System.Drawing.Size(912, 160);
            this.grpReading.TabIndex = 48;
            this.grpReading.TabStop = false;
            this.grpReading.Text = "Reading Tags: ";
            this.grpReading.Visible = false;
            // 
            // grpG2Reading
            // 
            this.grpG2Reading.Controls.Add(this.btnG2Read);
            this.grpG2Reading.Controls.Add(this.label19);
            this.grpG2Reading.Controls.Add(this.label20);
            this.grpG2Reading.Controls.Add(this.nudWordPtr);
            this.grpG2Reading.Controls.Add(this.lblG2ReadResponse);
            this.grpG2Reading.Controls.Add(this.cboG2Bank);
            this.grpG2Reading.Controls.Add(this.nudWordLen);
            this.grpG2Reading.Controls.Add(this.label16);
            this.grpG2Reading.Controls.Add(this.label21);
            this.grpG2Reading.Location = new System.Drawing.Point(16, 96);
            this.grpG2Reading.Name = "grpG2Reading";
            this.grpG2Reading.Size = new System.Drawing.Size(880, 56);
            this.grpG2Reading.TabIndex = 39;
            this.grpG2Reading.TabStop = false;
            this.grpG2Reading.Text = "Gen2 specific Reading:";
            // 
            // btnG2Read
            // 
            this.btnG2Read.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnG2Read.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnG2Read.Location = new System.Drawing.Point(408, 16);
            this.btnG2Read.Name = "btnG2Read";
            this.btnG2Read.Size = new System.Drawing.Size(56, 32);
            this.btnG2Read.TabIndex = 38;
            this.btnG2Read.Text = "G2&Read";
            this.btnG2Read.UseVisualStyleBackColor = false;
            this.btnG2Read.Click += new System.EventHandler(this.btnG2Read_Click);
            // 
            // label19
            // 
            this.label19.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label19.Location = new System.Drawing.Point(152, 16);
            this.label19.Name = "label19";
            this.label19.Size = new System.Drawing.Size(64, 32);
            this.label19.TabIndex = 11;
            this.label19.Text = "Word Pointer (0 - 2097151)";
            this.label19.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label20
            // 
            this.label20.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label20.Location = new System.Drawing.Point(16, 16);
            this.label20.Name = "label20";
            this.label20.Size = new System.Drawing.Size(32, 32);
            this.label20.TabIndex = 11;
            this.label20.Text = "Gen2 Bank:";
            this.label20.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // nudWordPtr
            // 
            this.nudWordPtr.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudWordPtr.Location = new System.Drawing.Point(216, 24);
            this.nudWordPtr.Maximum = new decimal(new int[] {
            2091140,
            0,
            0,
            0});
            this.nudWordPtr.Name = "nudWordPtr";
            this.nudWordPtr.Size = new System.Drawing.Size(64, 18);
            this.nudWordPtr.TabIndex = 12;
            this.nudWordPtr.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // lblG2ReadResponse
            // 
            this.lblG2ReadResponse.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblG2ReadResponse.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblG2ReadResponse.Location = new System.Drawing.Point(536, 24);
            this.lblG2ReadResponse.Name = "lblG2ReadResponse";
            this.lblG2ReadResponse.Size = new System.Drawing.Size(336, 24);
            this.lblG2ReadResponse.TabIndex = 13;
            this.lblG2ReadResponse.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.lblG2ReadResponse, "Shows current tag read");
            // 
            // cboG2Bank
            // 
            this.cboG2Bank.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboG2Bank.Items.AddRange(new object[] {
            "RESERVED",
            "EPC",
            "TID",
            "USER"});
            this.cboG2Bank.Location = new System.Drawing.Point(48, 24);
            this.cboG2Bank.Name = "cboG2Bank";
            this.cboG2Bank.Size = new System.Drawing.Size(88, 21);
            this.cboG2Bank.TabIndex = 17;
            // 
            // nudWordLen
            // 
            this.nudWordLen.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudWordLen.Location = new System.Drawing.Point(336, 24);
            this.nudWordLen.Maximum = new decimal(new int[] {
            32,
            0,
            0,
            0});
            this.nudWordLen.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudWordLen.Name = "nudWordLen";
            this.nudWordLen.Size = new System.Drawing.Size(40, 18);
            this.nudWordLen.TabIndex = 12;
            this.nudWordLen.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudWordLen.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            // 
            // label16
            // 
            this.label16.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label16.Location = new System.Drawing.Point(288, 16);
            this.label16.Name = "label16";
            this.label16.Size = new System.Drawing.Size(48, 32);
            this.label16.TabIndex = 11;
            this.label16.Text = "Word Len (1 - 32):";
            this.label16.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label21
            // 
            this.label21.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label21.Location = new System.Drawing.Point(488, 24);
            this.label21.Name = "label21";
            this.label21.Size = new System.Drawing.Size(24, 24);
            this.label21.TabIndex = 6;
            this.label21.Text = ">>>";
            // 
            // lblCurrentTag
            // 
            this.lblCurrentTag.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblCurrentTag.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCurrentTag.Location = new System.Drawing.Point(552, 53);
            this.lblCurrentTag.Name = "lblCurrentTag";
            this.lblCurrentTag.Size = new System.Drawing.Size(336, 23);
            this.lblCurrentTag.TabIndex = 13;
            this.lblCurrentTag.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.toolTip1.SetToolTip(this.lblCurrentTag, "Shows current tag read");
            // 
            // nudEnterWakes
            // 
            this.nudEnterWakes.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudEnterWakes.Location = new System.Drawing.Point(88, 24);
            this.nudEnterWakes.Maximum = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.nudEnterWakes.Name = "nudEnterWakes";
            this.nudEnterWakes.Size = new System.Drawing.Size(40, 18);
            this.nudEnterWakes.TabIndex = 12;
            this.nudEnterWakes.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudEnterWakes.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudEnterWakes.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudEnterWakes.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // label8
            // 
            this.label8.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label8.Location = new System.Drawing.Point(24, 20);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(59, 24);
            this.label8.TabIndex = 11;
            this.label8.Text = "Enter Wakes (0-5):";
            this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // nudExitWakes
            // 
            this.nudExitWakes.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudExitWakes.Location = new System.Drawing.Point(88, 64);
            this.nudExitWakes.Name = "nudExitWakes";
            this.nudExitWakes.Size = new System.Drawing.Size(40, 18);
            this.nudExitWakes.TabIndex = 12;
            this.nudExitWakes.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudExitWakes.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudExitWakes.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // nudQ
            // 
            this.nudQ.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudQ.Location = new System.Drawing.Point(384, 24);
            this.nudQ.Maximum = new decimal(new int[] {
            7,
            0,
            0,
            0});
            this.nudQ.Name = "nudQ";
            this.nudQ.Size = new System.Drawing.Size(40, 18);
            this.nudQ.TabIndex = 12;
            this.nudQ.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudQ.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudQ.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // label15
            // 
            this.label15.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label15.Location = new System.Drawing.Point(344, 24);
            this.label15.Name = "label15";
            this.label15.Size = new System.Drawing.Size(40, 16);
            this.label15.TabIndex = 11;
            this.label15.Text = "Q (0 - 7):";
            this.label15.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label9
            // 
            this.label9.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label9.Location = new System.Drawing.Point(24, 56);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(56, 24);
            this.label9.TabIndex = 11;
            this.label9.Text = "Exit Wakes (0 - 100):";
            this.label9.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // nudSession
            // 
            this.nudSession.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudSession.Location = new System.Drawing.Point(384, 64);
            this.nudSession.Maximum = new decimal(new int[] {
            3,
            0,
            0,
            0});
            this.nudSession.Name = "nudSession";
            this.nudSession.Size = new System.Drawing.Size(40, 18);
            this.nudSession.TabIndex = 12;
            this.nudSession.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudSession.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudSession.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudSession.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // nudCycles
            // 
            this.nudCycles.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudCycles.Location = new System.Drawing.Point(288, 24);
            this.nudCycles.Maximum = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.nudCycles.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudCycles.Name = "nudCycles";
            this.nudCycles.Size = new System.Drawing.Size(40, 18);
            this.nudCycles.TabIndex = 12;
            this.nudCycles.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudCycles.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudCycles.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudCycles.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // nudCount
            // 
            this.nudCount.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudCount.Location = new System.Drawing.Point(288, 64);
            this.nudCount.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.nudCount.Name = "nudCount";
            this.nudCount.Size = new System.Drawing.Size(40, 18);
            this.nudCount.TabIndex = 12;
            this.nudCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudCount.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.nudCount.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudCount.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // label10
            // 
            this.label10.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label10.Location = new System.Drawing.Point(344, 56);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(40, 24);
            this.label10.TabIndex = 11;
            this.label10.Text = "Session (0 - 3):";
            this.label10.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label12
            // 
            this.label12.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label12.Location = new System.Drawing.Point(240, 56);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(38, 24);
            this.label12.TabIndex = 11;
            this.label12.Text = "Count (1-100):";
            this.label12.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label11
            // 
            this.label11.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label11.Location = new System.Drawing.Point(240, 19);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(40, 24);
            this.label11.TabIndex = 11;
            this.label11.Text = "Cycles (1-5):";
            this.label11.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // nudSleeps
            // 
            this.nudSleeps.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudSleeps.Location = new System.Drawing.Point(176, 48);
            this.nudSleeps.Maximum = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.nudSleeps.Name = "nudSleeps";
            this.nudSleeps.Size = new System.Drawing.Size(40, 18);
            this.nudSleeps.TabIndex = 12;
            this.nudSleeps.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.nudSleeps.Leave += new System.EventHandler(this.myNUD_Leave);
            this.nudSleeps.Enter += new System.EventHandler(this.myNUD_Enter);
            // 
            // label14
            // 
            this.label14.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label14.Location = new System.Drawing.Point(144, 40);
            this.label14.Name = "label14";
            this.label14.Size = new System.Drawing.Size(32, 29);
            this.label14.TabIndex = 11;
            this.label14.Text = "Sleeps (0-5):";
            this.label14.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label17
            // 
            this.label17.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label17.Location = new System.Drawing.Point(480, 56);
            this.label17.Name = "label17";
            this.label17.Size = new System.Drawing.Size(64, 24);
            this.label17.TabIndex = 11;
            this.label17.Text = "Current ID: ";
            this.label17.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // label18
            // 
            this.label18.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label18.Location = new System.Drawing.Point(496, 32);
            this.label18.Name = "label18";
            this.label18.Size = new System.Drawing.Size(40, 8);
            this.label18.TabIndex = 11;
            this.label18.Text = "Mask:";
            this.label18.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // txtMask
            // 
            this.txtMask.Location = new System.Drawing.Point(552, 24);
            this.txtMask.MaxLength = 36;
            this.txtMask.Name = "txtMask";
            this.txtMask.Size = new System.Drawing.Size(336, 20);
            this.txtMask.TabIndex = 8;
            this.txtMask.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.toolTip1.SetToolTip(this.txtMask, "Type in mask in Hexadecimal format and hit ENTER at the end.");
            this.txtMask.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtMask_KeyUp);
            // 
            // lblTagReadStatus
            // 
            this.lblTagReadStatus.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblTagReadStatus.Location = new System.Drawing.Point(552, 77);
            this.lblTagReadStatus.Name = "lblTagReadStatus";
            this.lblTagReadStatus.Size = new System.Drawing.Size(336, 16);
            this.lblTagReadStatus.TabIndex = 11;
            this.lblTagReadStatus.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblCurrentTagStatus
            // 
            this.lblCurrentTagStatus.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCurrentTagStatus.Location = new System.Drawing.Point(552, 48);
            this.lblCurrentTagStatus.Name = "lblCurrentTagStatus";
            this.lblCurrentTagStatus.Size = new System.Drawing.Size(312, 8);
            this.lblCurrentTagStatus.TabIndex = 11;
            this.lblCurrentTagStatus.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // grpProgramming
            // 
            this.grpProgramming.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.grpProgramming.Controls.Add(this.cboProgramCommands);
            this.grpProgramming.Controls.Add(this.txtProgramData);
            this.grpProgramming.Controls.Add(this.btnSend);
            this.grpProgramming.Controls.Add(this.cboProgramOptions);
            this.grpProgramming.Controls.Add(this.label1);
            this.grpProgramming.Controls.Add(this.label3);
            this.grpProgramming.Controls.Add(this.label7);
            this.grpProgramming.Controls.Add(this.grpProgramAntenna);
            this.grpProgramming.Controls.Add(this.grpProgramProtocol);
            this.grpProgramming.Controls.Add(this.grpWriteParms);
            this.grpProgramming.Location = new System.Drawing.Point(8, 304);
            this.grpProgramming.Name = "grpProgramming";
            this.grpProgramming.Size = new System.Drawing.Size(912, 208);
            this.grpProgramming.TabIndex = 48;
            this.grpProgramming.TabStop = false;
            this.grpProgramming.Text = "Programming: ";
            this.grpProgramming.Visible = false;
            // 
            // cboProgramCommands
            // 
            this.cboProgramCommands.Location = new System.Drawing.Point(24, 112);
            this.cboProgramCommands.Name = "cboProgramCommands";
            this.cboProgramCommands.Size = new System.Drawing.Size(344, 21);
            this.cboProgramCommands.TabIndex = 0;
            this.cboProgramCommands.SelectedIndexChanged += new System.EventHandler(this.cboProgramCommands_SelectedIndexChanged);
            // 
            // btnSend
            // 
            this.btnSend.Anchor = System.Windows.Forms.AnchorStyles.None;
            this.btnSend.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnSend.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnSend.Location = new System.Drawing.Point(416, 152);
            this.btnSend.Name = "btnSend";
            this.btnSend.Size = new System.Drawing.Size(88, 32);
            this.btnSend.TabIndex = 37;
            this.btnSend.Text = "&Send";
            this.toolTip1.SetToolTip(this.btnSend, "Send a programming command or ");
            this.btnSend.UseVisualStyleBackColor = false;
            this.btnSend.Click += new System.EventHandler(this.btnSend_Click);
            // 
            // cboProgramOptions
            // 
            this.cboProgramOptions.Location = new System.Drawing.Point(392, 112);
            this.cboProgramOptions.Name = "cboProgramOptions";
            this.cboProgramOptions.Size = new System.Drawing.Size(128, 21);
            this.cboProgramOptions.TabIndex = 0;
            // 
            // label1
            // 
            this.label1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label1.Location = new System.Drawing.Point(32, 96);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(72, 16);
            this.label1.TabIndex = 6;
            this.label1.Text = "Command:";
            // 
            // label3
            // 
            this.label3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label3.Location = new System.Drawing.Point(400, 96);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(48, 16);
            this.label3.TabIndex = 6;
            this.label3.Text = "Options: ";
            // 
            // label7
            // 
            this.label7.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label7.Location = new System.Drawing.Point(544, 96);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(104, 16);
            this.label7.TabIndex = 6;
            this.label7.Text = "Data Field:";
            // 
            // grpWriteParms
            // 
            this.grpWriteParms.Controls.Add(this.label23);
            this.grpWriteParms.Controls.Add(this.nudWordPtr2);
            this.grpWriteParms.Location = new System.Drawing.Point(544, 144);
            this.grpWriteParms.Name = "grpWriteParms";
            this.grpWriteParms.Size = new System.Drawing.Size(344, 56);
            this.grpWriteParms.TabIndex = 45;
            this.grpWriteParms.TabStop = false;
            this.grpWriteParms.Visible = false;
            // 
            // label23
            // 
            this.label23.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label23.Location = new System.Drawing.Point(24, 16);
            this.label23.Name = "label23";
            this.label23.Size = new System.Drawing.Size(152, 32);
            this.label23.TabIndex = 11;
            this.label23.Text = "Word Pointer (0 - 2097151)";
            this.label23.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // nudWordPtr2
            // 
            this.nudWordPtr2.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.nudWordPtr2.Location = new System.Drawing.Point(184, 24);
            this.nudWordPtr2.Maximum = new decimal(new int[] {
            2091140,
            0,
            0,
            0});
            this.nudWordPtr2.Name = "nudWordPtr2";
            this.nudWordPtr2.Size = new System.Drawing.Size(64, 18);
            this.nudWordPtr2.TabIndex = 12;
            this.nudWordPtr2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // timer1
            // 
            this.timer1.Enabled = true;
            this.timer1.Interval = 5000;
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // Form11
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.BackColor = System.Drawing.Color.Black;
            this.ClientSize = new System.Drawing.Size(936, 589);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.grpReading);
            this.Controls.Add(this.grpProgramming);
            this.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.Name = "Form11";
            this.Text = "Form1";
            this.Load += new System.EventHandler(this.form_Load);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.form_Closing);
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).EndInit();
            this.grpConnection.ResumeLayout(false);
            this.grpSerial.ResumeLayout(false);
            this.grpNetwork.ResumeLayout(false);
            this.grpNetwork.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).EndInit();
            this.groupBox1.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.grpProgramAntenna.ResumeLayout(false);
            this.grpProgramAntenna.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar1)).EndInit();
            this.grpProgramProtocol.ResumeLayout(false);
            this.grpReading.ResumeLayout(false);
            this.grpReading.PerformLayout();
            this.grpG2Reading.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.nudWordPtr)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudWordLen)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudEnterWakes)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudExitWakes)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudQ)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudSession)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudCycles)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudCount)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.nudSleeps)).EndInit();
            this.grpProgramming.ResumeLayout(false);
            this.grpProgramming.PerformLayout();
            this.grpWriteParms.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.nudWordPtr2)).EndInit();
            this.ResumeLayout(false);

		}



		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form11());
		}
		#endregion


		protected void form_Load(object sender, System.EventArgs e)
		{
            string exePath = Application.ExecutablePath;
            int idx = exePath.LastIndexOf("\\");
            if (idx != -1)
                AlienLog.Path = exePath.Substring(0, idx + 1);
            AlienLog.WriteLine(true, "Starting the 'Ex11-Programming Tags' application.");

            mReader = new clsReader(true);

            mReader.Disconnected += new nsAlienRFID2.CBaseReader.DisconnectedEventHandler(mReader_Disconnected);
//			mReader.MessageReceived += new nsAlienRFID.CBaseReader.MessageReceivedEventHandler(mReader_MessageReceived);
			mReaderInfo = mReader.ReaderSettings;

            AlienLog.Path = "C:\\";

			this.Text = "Alien Library .NET - Testing Programming Tags";
			Thread.CurrentThread.Name = "Alien-Ex.11: Programming Tags";

		}

		private void form_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (mReader != null)
			{
				mReader.Dispose();
				mReader = null;
			}
		}



		#region "Connection"
		private void PortUD_ValueChanged(object sender, System.EventArgs e)
		{
			mReaderInfo.TelnetPort = Convert.ToInt32(PortUD.Value);
			mReader.ReaderSettings = mReaderInfo;
		}
		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			String result;
			this.Cursor = Cursors.WaitCursor;
			try		// extra precausion though it shouldn't throw exceptions
			{
				if (meReaderInterface == ComInterface.enumTCPIP)
					mReader.InitOnNetwork(txtIPAddress.Text, Convert.ToInt32(PortUD.Value));
				else
					mReader.InitOnCom();

				lblStatus.Text = "Connecting to the reader...";

				result = mReader.Connect();
				if (mReader.IsConnected)
				{
					if (meReaderInterface == ComInterface.enumTCPIP)
					{
						lblStatus.Text = "Logging in...";
						this.Cursor = Cursors.WaitCursor;
						if (!mReader.Login("alien", "password"))		//returns result synchronously
						{
							lblStatus.Text = "Login failed! Calling Disconnect()...";
							mReader.Disconnect();
							return;				//------------>
						}
					}
					configureGUI(true);
				}
			}
			catch(Exception ex)
			{
				lblStatus.Text = "Exception in btnConnect_Click(): " + ex.Message;
			}
			this.Cursor = Cursors.Default;
		}

		private void btnDisconnect_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
			if (mReader.IsConnected)
			{
				mReader.Disconnect();
				this.Cursor = Cursors.Default;	
			}
			configureGUI(false);
		}

		private void rdoSerial_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoSerial.Checked;
			grpSerial.Enabled = state;
			grpNetwork.Enabled = !state;
			btnConnect.Text = (state ? "&Connect" : "&Connect + Login");
			meReaderInterface = (state ? ComInterface.enumSerial : ComInterface.enumTCPIP);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
			cboPorts.SelectedIndex = 0;
			cboHostBaudRate.SelectedIndex = 0;
		}

		private void rdoTCP_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoTCP.Checked;
			grpSerial.Enabled = !state;
			grpNetwork.Enabled = state;
			btnConnect.Text = (state ? "&Connect + Login" : "&Connect" );
			meReaderInterface = (state ? ComInterface.enumTCPIP : ComInterface.enumSerial);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
			txtIPAddress.Select();
		}

		private void cboPorts_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			mReader.SerialPort = cboPorts.Text;
		}

		private void cboHostBaudRate_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cboHostBaudRate.Enabled)
			{
				try { mReader.HostBaudRate = int.Parse(cboHostBaudRate.Text); }
				catch (Exception ex) { lblStatus.Text = ex.Message; }
			}
		}

		private void chkKeepConnectionAlive_CheckedChanged(object sender, System.EventArgs e)
		{
			mReader.KeepNetworkConnectionAlive = chkKeepConnectionAlive.Checked;
		}

		#endregion

		private void displayText(String data)
		{
			try
			{
				if (this.InvokeRequired)	//should not be needed here: all communications are synchronous
				{
					object[] temp = {data};
					IAsyncResult ars = this.BeginInvoke(new displayMessageDlgt(displayText),temp);
					this.EndInvoke(ars);
					return;
				}
				else
				{	
					if ((data.IndexOf("Bye!") > 0) || (data.IndexOf("Disconnected") > 0))
					{
						configureGUI(false);
					}

					return;
				}
			}
			catch(Exception ex)
			{
				Debug.WriteLine("Exception in the DiscplayText: " + ex.Message);
			}
		}

		private void configureGUI (bool bConnected)
		{
			btnDisconnect.Enabled = bConnected;
			btnConnect.Enabled = !bConnected;
			grpConnection.Enabled = !bConnected;

			lblStatus.Text = bConnected ? "Connected." : "Disconnected.";
			if (meReaderInterface == ComInterface.enumTCPIP)
				grpNetwork.Enabled = !bConnected;
			else
				grpSerial.Enabled = !bConnected;	

			if (bConnected)
			{
				#region "ProgramCommands"
				cboProgramCommands.Items.Clear();
				try 
				{
					string readerVersion = mReader.ReaderVersion;
					string readerType = mReader.ReaderType;

					cboProgramCommands.Items.AddRange(mOldCommands);

					meReaderType = eReaderType.x900;

					if ((readerType.IndexOf("780") != -1) ||
						(readerType.IndexOf("9640") != -1))
					{
						meReaderType = eReaderType.x780;
						rdoClass0.Enabled = false;
					}
					else if ((readerType.IndexOf("9900") != -1) ||
							 (readerType.IndexOf("9650") != -1))
					{
						meReaderType = eReaderType.x900;
						cboProgramCommands.Items.AddRange(mNewCommands);
						rdoClass0.Enabled = false;
						rdoClass1.Enabled = false;
					}
					else if (((readerType.ToLower().IndexOf("alr-98") != -1) ||
						(readerType.ToLower().IndexOf("alr-88") != -1)) &&
						(String.Compare(readerVersion, "07.08.14.00") >= 0))
					{
						meReaderType = eReaderType.x800;
						cboProgramCommands.Items.AddRange(mNewCommands);
						rdoClass0.Enabled = true;
						rdoClass1.Enabled = true;
					}
				}
				catch (Exception ex) { lblStatus.Text = ex.Message; }
				#endregion

				grpG2Reading.Enabled = (meReaderType != eReaderType.x780);

				#region "Antennae & Power"
				try 
				{
                    if (meReaderType == eReaderType.x900)
                    {
                        //int maxAntenna = mReader.MaxAntenna;
                        //rdoAntenna2.Enabled = (maxAntenna < 3) ? false : true;
                        //rdoAntenna3.Enabled = (maxAntenna < 3) ? false : true;
                        bool[] antennae = mReader.GetAllAntennaStatus();
                        for (int i = 0; i < antennae.Length; i++)
                        {
                            switch (i)
                            {
                                case 0: rdoAntenna0.Enabled = antennae[i]; break;
                                case 1: rdoAntenna1.Enabled = antennae[i]; break;
                                case 2: rdoAntenna2.Enabled = antennae[i]; break;
                                case 3: rdoAntenna3.Enabled = antennae[i]; break;
                                default: break;
                            }

                        }
                        //rdoAntenna0.Enabled = mReader.IsAntennaConnected("0");
                        //rdoAntenna1.Enabled = mReader.IsAntennaConnected("1");
                    }
                    //else  enable all antennas because of unsupported AntennaStatus...
                    
					string antenna = mReader.ProgAntenna;
					switch (antenna)
					{
						case "0": rdoAntenna0.Checked = true; break;
						case "1": rdoAntenna1.Checked = true; break;
						case "2": rdoAntenna2.Checked = true; break;
						case "3": rdoAntenna3.Checked = true; break;
						default: lblStatus.Text = antenna; break;
					}
					int antennaPower = mReader.GetAntennaPower(antenna);
					txtAntennaPower.Text = antennaPower.ToString();
					trackBar1.Value = antennaPower;
				}
				catch (Exception ex) { lblStatus.Text = ex.Message; }
				#endregion

				#region "ProgProtocol"
				rdoClass1.Checked = true;
				try
				{
					int iProgProtocol = mReader.ProgProtocol;
					if (iProgProtocol == 2)
						rdoGen2.Checked = true;

				}
				catch(Exception ex) { lblStatus.Text = ex.Message; }
				#endregion

				try { txtMask.Text = mReader.Mask; }
				catch (Exception ex) { lblStatus.Text = ex.Message; }

				#region "Configure reader for programming"

				try { mReader.AutoMode = "Off"; mReader.NotifyMode = "Off"; }
				catch (Exception ex) { lblStatus.Text = ex.Message; }

				try 
				{ 
					mReader.TagListFormat = "Text"; 
					mReader.PersistTime = "-1"; 
					mReader.AcquireMode = "Global Scroll"; 
				}
				catch (Exception ex) { lblStatus.Text = ex.Message; }

				try { mReader.Function = "Programmer"; }
				catch (Exception ex) { lblStatus.Text = ex.Message; }

				if (meReaderType > eReaderType.x780)
				{
					try { mReader.IOStreamMode = "Off"; mReader.TagStreamMode = "Off"; }
					catch (Exception ex) { lblStatus.Text = ex.Message; }
				}

				#endregion
			}

			grpReading.Visible = bConnected;
			grpProgramming.Visible = bConnected;
		}


		private void mReader_Disconnected(string data)
		{
			displayText(data);
		}


		
		private void txtAntennaPower_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				int iValue = -1;
				try 
				{
					iValue = int.Parse(txtAntennaPower.Text);
					if (setAntennaPower(iValue))
						trackBar1.Value = iValue;
				}
				catch(Exception ex)
				{
					txtAntennaPower.Text = trackBar1.Value.ToString();
					lblStatus.Text = ex.Message;
				}
			}
		}
		private void trackBar1_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (setAntennaPower(trackBar1.Value))
				txtAntennaPower.Text = trackBar1.Value.ToString();
		}
		private bool setAntennaPower(int iValue)
		{
			bool result = false;

			string antennaName = null;
            if (rdoAntenna0.Checked)
                antennaName = "0";
            else if (rdoAntenna1.Checked)
                antennaName = "1";
            else if (rdoAntenna2.Checked)
                antennaName = "2";
            else
                antennaName = "3";
            Stopwatch watcher = new Stopwatch();
			try 
			{
                AlienLog.WriteLine(true, "Before calling the 'SetAntennaPower()'...");
                watcher.Start();

				mReader.SetAntennaPower(antennaName, iValue);

                watcher.Stop();
                AlienLog.WriteLine(true, "After calling the 'SetAntennaPower()' - elapsed msec = " + watcher.ElapsedMilliseconds.ToString());
				
                result = true;
				lblStatus.Text = "Ready";
			}
			catch (Exception ex)
			{
				lblStatus.Text = ex.Message;
			}
			return result;
		}

		
		private void cboProgramCommands_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			cboProgramOptions.Text = "";
			cboProgramOptions.Items.Clear();
			txtProgramData.Text = "";

			object currentOption = null;

			grpWriteParms.Visible = false;

			string command = cboProgramCommands.Text;
			try 
			{
				if (command != "")
				{
					switch (command)
					{
						case "Program Tag": 
							lblStatus.Text = "Enter tag ID.";
							promptProgramData(msLastTagID);
							break;
						case "Erase Tag":
							if (rdoGen2.Checked)
							{
								lblStatus.Text = "Gen2 tags don't support 'Erase' command.";
								cboProgramCommands.DroppedDown = true;
							}
							else
								btnSend.Focus();
							break;
						case "Lock Tag":
							lblStatus.Text = "Enter one byte pass code.";
							promptProgramData(null); 
							break;
						case "Kill Tag":
							lblStatus.Text = "Enter one byte pass code.";
							promptProgramData(null); 
							break;
						case "ProgIncrementOnFail":
							cboProgramOptions.Items.AddRange(new string[] { "On", "Off" });
							currentOption = mReader.ProgIncrementOnFail;
							lblStatus.Text = "Select option.";
							break;
						case "ProgramPassCode":
							lblStatus.Text = "Enter one byte pass code.";
							promptProgramData(null); 
							break;
						case "ProgramID":
							lblStatus.Text = "Enter ID as hexadecimal string.";
							promptProgramData(mReader.ProgramID); 
							break;
						case "ProgAttempts":
							lblStatus.Text = "Enter integer number.";
							promptProgramData(mReader.ProgAttempts.ToString()); 
							break;
						case "ProgEraseAttempts":
							lblStatus.Text = "Enter integer number.";
							promptProgramData(mReader.ProgEraseAttempts.ToString()); 
							break;
						case "ProgReadAttempts":
							lblStatus.Text = "Enter integer number.";
							promptProgramData(mReader.ProgReadAttempts.ToString()); 
							break;
						case "ProgSuccessFormat":
							cboProgramOptions.Items.AddRange(
								new string[] {	eProgramSuccessFormat.Success.ToString(), 
												 eProgramSuccessFormat.TagData.ToString() });
							currentOption = (eProgramSuccessFormat)mReader.ProgSuccessFormat;
							lblStatus.Text = "Select option.";
							break;

						case "ProgramEPC":
							lblStatus.Text = "Leave empty data field to use an ID predefined by the 'ProgEPCData' command or enter new tag ID.";
							promptProgramData(msLastTagID);
							break;
						case "ProgramAndLockEPC":
							lblStatus.Text = "Leave empty data field to use an ID predefined by the 'ProgEPCData' command or enter new tag ID.";
							promptProgramData(msLastTagID);
							break;
						case "ProgramUser":
							lblStatus.Text = "Leave empty data field to use data predefined by the 'ProgUserData' command or enter new data.";
							promptProgramData(null);
							break;
						case "ProgramAndLockUser":
							lblStatus.Text = "Leave empty data field to use data predefined by the 'ProgUserData' command or enter new data.";
							promptProgramData(null);
							break;
						case "ProgramKillPwd":
							lblStatus.Text = "Leave empty data field to use Kill password predefined by the 'ProgG2KillPwd' command or enter new 4 bytes Kill Password.";
							promptProgramData(null);
							break;
						case "ProgramAccessPwd":
							lblStatus.Text = "Leave empty data field to use Access password predefined by the 'ProgG2AccessPwd' command or enter new 4 bytes Access Password.";
							promptProgramData(null);
							break;

						case "ProgEPCData":
							lblStatus.Text = "Enter new tag ID to use with a subsequent 'ProgramEPC' command.";
							promptProgramData(mReader.ProgEPCData);
							break;
						case "ProgEPCDataInc":
							cboProgramOptions.Items.AddRange(Enum.GetNames(typeof(eProgIncrement)));
							currentOption = mReader.ProgEPCDataInc;
							lblStatus.Text = "Select option.";
							break;
						case "ProgC1KillPwd":
							lblStatus.Text = "Enter one byte kill password (pass code.)";
							promptProgramData(null); 
							break;
						case "ProgG2KillPwd":
							lblStatus.Text = "Enter 4 byte kill password to use with the 'ProgramKillPwd' command.";
							promptProgramData(null); 
							break;
						case "ProgG2AccessPwd":
							lblStatus.Text = "Enter 4 byte access password to use with the 'ProgramAccessPwd' command.";
							promptProgramData(null); 
							break;

						case "AcqG2AccessPwd":
							lblStatus.Text = "Enter 4 byte access password to change current access password in a tag.";
							promptProgramData(null); 
							break;

						case "ProgUserData":
							lblStatus.Text = "Enter new user data to use with a subsequent 'ProgramUser' command.";
							promptProgramData(mReader.ProgUserData);
							break;
						case "ProgUserDataInc":
							cboProgramOptions.Items.AddRange(Enum.GetNames(typeof(eProgIncrement)));
							currentOption = mReader.ProgUserData;
							lblStatus.Text = "Select option.";
							break;
						case "ProgG2LockType":
							cboProgramOptions.Items.AddRange(Enum.GetNames(typeof(eLockType)));
							currentOption = mReader.ProgG2LockType;
							lblStatus.Text = "Select option.";
							break;

						case "Lock":
						case "Unlock":
						{
							string[] options = Enum.GetNames(typeof(eLockTarget));
							cboProgramOptions.Items.AddRange(options);
							currentOption = options[0];
							promptProgramData(null);
							lblStatus.Text = "Select Option and enter access password if needed.";
							break;
						}
						case "G2Write":
						{
							cboProgramOptions.Items.AddRange(new string[] { "RESERVED", "EPC", "TID", "USER" });
							currentOption = cboG2Bank.Items[1];		//  the EPC bank or any other to begin with ...
							grpWriteParms.Visible = true;
							promptProgramData(null);
							lblStatus.Text = "Select Option and Word Pointer, enter data (as a hexadecimal string with spaces) to write.";
							break;
						}
						case "ProgramAlienImage":
						{
							lblStatus.Text = "Leave empty data field to use data predefined by other properties or enter new data.";
							promptProgramData(null);
							break;
						}
						case "ProgAlienImageMap":
						{
							cboProgramOptions.Items.AddRange(new string[] {"EPC96", "EPC128", "EPC96USER64"} );
							currentOption = mReader.ProgAlienImageMap;
							lblStatus.Text = "Select an option.";
							break;
						}
						case "ProgAlienImageNSI":
						{
							lblStatus.Text = "Enter/ modify a hexadecimal string of data to program as an NSI field with a subsequent ProgramAlienImage command.";
							promptProgramData(mReader.ProgAlienImageNSI);
							break;
						}
						default: break;

					}

				}
				if (currentOption != null)
				{
					cboProgramOptions.Text = currentOption.ToString();
					cboProgramOptions.DroppedDown = true;
				}
			}
			catch (Exception ex)
			{
					lblStatus.Text = ex.Message;
			}				
		}

		private void promptProgramData(string data)
		{
			if ((data == null) || (data.Trim() == ""))
                txtProgramData.Text = "   ";
			else
				txtProgramData.Text = data;
			txtProgramData.SelectionStart = 0;  
			txtProgramData.SelectionLength = txtProgramData.Text.Length;
			txtProgramData.Focus();
		}
		
		
		private void rdoAntenna_Clicked(object sender, System.EventArgs e)
		{
			RadioButton rdo = sender as RadioButton;
			if (rdo.Checked)
			{
				string antennaName = rdo.Name.Substring(10, 1);
				try 
				{
					mReader.ProgAntenna = antennaName;
					showAntenna(antennaName);
				}
				catch (Exception ex)
				{
					lblStatus.Text = ex.Message;
				}
			}
		}

		private void showAntenna(string antennaName)
		{
			try 
			{
				int antennaPower = mReader.GetAntennaPower(antennaName);
				txtAntennaPower.Text = antennaPower.ToString();
				trackBar1.Value = antennaPower;
			}
			catch (Exception ex)
			{
				lblStatus.Text = ex.Message;
			}
		}

		private void rdoAntenna_CheckedChanged(object sender, System.EventArgs e)
		{
			RadioButton rdo = sender as RadioButton;
			if (rdo.Checked)
			{
				string antennaName = rdo.Name.Substring(10, 1);
				showAntenna(antennaName);
			}
		}

		

		private bool checkProtocol(int protocol)
		{
			bool supported = true;
			if (protocol == 2)
			{
				try { mReader.TagType = 16; } 
				catch (Exception ex) { supported = false; lblStatus.Text = ex.Message; }
			}
			else 
			{
				try { mReader.TagType = 7; } 
				catch (Exception ex) { supported = false; lblStatus.Text = ex.Message; }
			}
			return supported;
		}

//		private bool showProtocol(int protocol)		// todo: fix and call to validate and set new protocol's properties ...
//		{
//			bool supported = checkProtocol(protocol);
//			if (supported)
//			{
//				nudEnterWakes.Enabled = false;
//				nudExitWakes.Enabled = false;
//				nudSleeps.Enabled = false;
//				nudQ.Enabled = true;
//				nudSession.Enabled = true;
//
//				try { nudQ.Value = decimal.Parse(mReader.AcqG2Q); } 
//				catch (Exception ex) { lblStatus.Text = ex.Message; }
//				try { nudSession.Value = decimal.Parse(mReader.AcqG2Session); } 
//				catch (Exception ex) { lblStatus.Text = ex.Message; }
//                   
//				string tooltip = (meReaderType > eReaderType.x780) ? G2MASK : C1MASK;
//				toolTip1.SetToolTip(this.txtMask, tooltip);
//
//				nudEnterWakes.Enabled = true;
//				nudExitWakes.Enabled = true;
//				nudSleeps.Enabled = true;
//				nudQ.Enabled = false;
//				nudSession.Enabled = false;
//
//				try { nudEnterWakes.Value = decimal.Parse(mReader.AcqC1EnterWakeCount); } 
//				catch (Exception ex) { lblStatus.Text = ex.Message; }
//				try { nudExitWakes.Value = decimal.Parse(mReader.AcqC1ExitWakeCount); } 
//				catch (Exception ex) { lblStatus.Text = ex.Message; }
//				try { nudSleeps.Value = decimal.Parse(mReader.AcqC1SleepCount); } 
//				catch (Exception ex) { lblStatus.Text = ex.Message; } 
//
//				toolTip1.SetToolTip(this.txtMask, C1MASK);
//			}
//			try { nudCycles.Value = decimal.Parse(mReader.AcqG2Cycles); } 
//			catch (Exception ex) { lblStatus.Text = ex.Message; }
//			try { nudCount.Value = decimal.Parse(mReader.AcqG2Count); } 
//			catch (Exception ex) { lblStatus.Text = ex.Message; }
//
//			return supported;
//		}
//

		
		private void txtMask_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				string mask = txtMask.Text.Trim();
				try 
				{
					if (meReaderType == eReaderType.x780)
						mReader.Mask = mask; 
					else
						mReader.AcqG2Mask = mask;

					lblStatus.Text = "Mask set OK.";
				} 
				catch (Exception ex) { lblStatus.Text = ex.Message; }
			}
		}

		
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			if ((!mbDisposing) && (mReader.IsConnected))
			{
				if (!verifyTag())
					lblCurrentTag.BackColor = Color.Red;
				else
					lblCurrentTag.BackColor = Color.Green;
			}
		}

		protected bool verifyTag()
		{
			bool bReturn = false;

			string tagResponse = null;
			string tagID = null;

            //if (meReaderType == eReaderType.x780)
            //    tagResponse = mReader.VerifyTag();
            //else 
            if (rdoGen2.Checked)
			{
				try 
				{
					tagResponse = mReader.G2Read(eG2Bank.EPC, "2", "6");
					int len = tagResponse.Length;
					if (len >= 35)
						tagID = tagResponse.Substring(0, 35);
					else
						tagID = tagResponse.Substring(0, 23);

					msLastTagID = tagID.Trim();
					lblCurrentTag.Text = tagID.Trim();
					lblTagReadStatus.Text = "";
					bReturn = true;
				}
				catch (Exception ex)
				{
					lblTagReadStatus.Text = ex.Message;
					bReturn = false;
				}
			}
			else    // Class 1 Gen1
			{
				try 
				{
                    tagResponse = mReader.VerifyTag();
					tagID = tagResponse.Substring(5, tagResponse.Length - 10).Trim(); 
					if ((tagResponse.Trim().ToLower().IndexOf("no tag") >= 0) ||
						(tagResponse.Trim().ToLower().IndexOf("sniff") >= 0) ||
						(tagResponse.Trim().ToLower().IndexOf("tag-like") >= 0))
					{
						lblCurrentTag.Text = tagResponse;
						toolTip1.SetToolTip(lblCurrentTag, "Trouble reading tags.");
						lblTagReadStatus.Text = tagResponse;
						bReturn = false;
					}
					else
					{
						lblCurrentTag.Text = tagID;
						toolTip1.SetToolTip(lblCurrentTag, "Reading tags OK.");
						msLastTagID = tagID;
						lblTagReadStatus.Text = "";
						bReturn = true;
					}					
				}
				catch (Exception e)
				{
					lblTagReadStatus.Text = e.Message;
					bReturn = false;
				}
			}

			return bReturn;
		}


		
		private void myNUD_Leave(object sender, System.EventArgs e)
		{
			NumericUpDown nud = sender as NumericUpDown;
			if (nud.Value != mSavedNUDvalue)
			{
				this.Cursor = Cursors.WaitCursor;
				try 
				{
					string newValue = nud.Value.ToString();
					switch (nud.Name)
					{
						case "nudEnterWakes": mReader.AcqC1EnterWakeCount = newValue; break;
						case "nudExitWakes": mReader.AcqC1ExitWakeCount = newValue; break;
						case "nudSleeps": mReader.AcqC1SleepCount = newValue; break;

						case "nudCycles":
							if (rdoGen2.Checked)
								mReader.AcqG2Cycles = newValue;
							else
								mReader.AcqCycles = newValue;
							break;
						case "nudCount": 
							if (rdoGen2.Checked)
								mReader.AcqG2Count = newValue;
							else
								mReader.AcqCount = newValue;
							break;
						case "nudQ": mReader.AcqG2Q = newValue; break;
						case "nudSession": mReader.AcqG2Session = newValue; break;
						default: break;			
					}
					lblStatus.Text = nud.Name.Substring(3) + " set OK.";
				}
				catch (Exception ex) { lblStatus.Text = ex.Message; }
				this.Cursor = Cursors.Default;

			}

		}

		private void myNUD_Enter(object sender, System.EventArgs e)
		{
			NumericUpDown nud = sender as NumericUpDown;
			mSavedNUDvalue = nud.Value;
		}

		
		
		private void btnSend_Click(object sender, System.EventArgs e)
		{
			if (cboProgramCommands.SelectedIndex == -1)
			{
				lblStatus.Text = "Select a command.";
				cboProgramCommands.DroppedDown = true;
				return;
			}
			string command = cboProgramCommands.Text.Trim();
			string option = cboProgramOptions.Text.Trim();
			string data = txtProgramData.Text.Trim();
			string status = null;
			try 
			{
				switch (command)
				{
					case "Program Tag": status = mReader.ProgramTag(data); break;
					case "Erase Tag": status = mReader.EraseTag(); break;
					case "Lock Tag": status = mReader.LockTag(data); break;
					case "Kill Tag": status = mReader.KillTag(msLastTagID, data); break;
					case "ProgIncrementOnFail": mReader.ProgIncrementOnFail = option; break;
					case "ProgramPassCode": mReader.ProgramPassCode = data; break;
					case "ProgramID": mReader.ProgramID = data; break;
					case "ProgAttempts": mReader.ProgAttempts = int.Parse(data); break;
					case "ProgEraseAttempts": mReader.ProgEraseAttempts = int.Parse(data); break;
					case "ProgReadAttempts": mReader.ProgReadAttempts = int.Parse(data); break;
					case "ProgSuccessFormat": 
						eProgramSuccessFormat eCurrentFormat = 
							(eProgramSuccessFormat)(Enum.Parse(typeof(eProgramSuccessFormat), option));
						mReader.ProgSuccessFormat = (int)eCurrentFormat;
						break;
						
					case "ProgramEPC": status = mReader.ProgramEPC(data); break;
					case "ProgramAndLockEPC": status = mReader.ProgramAndLockEPC(data); break;
					case "ProgramUser": status = mReader.ProgramUser(data); break;
					case "ProgramAndLockUser": status = mReader.ProgramAndLockUser(data); break;
					case "ProgramKillPwd": status = mReader.ProgramKillPwd(data); break;
					case "ProgramAccessPwd": status = mReader.ProgramAccessPwd(data); break;
					case "ProgEPCData": mReader.ProgEPCData = data; break;
					case "ProgEPCDataInc": mReader.ProgEPCDataInc = option; break;
					case "ProgC1KillPwd": mReader.ProgC1KillPwd = data; break;
					case "ProgG2KillPwd": mReader.ProgG2KillPwd = data; break;
					case "ProgG2AccessPwd": mReader.ProgG2AccessPwd = data; break;
					case "AcqG2AccessPwd": mReader.AcqG2AccessPwd = data; break;
					case "ProgUserData": mReader.ProgUserData = data; break;
					case "ProgUserDataInc": mReader.ProgUserDataInc = option; break;
					case "ProgG2LockType": mReader.ProgG2LockType = option; break;
					case "Lock": mReader.Lock((eLockTarget)Enum.Parse(typeof(eLockTarget), option as String), data); break;
					case "Unlock": mReader.Unlock((eLockTarget)Enum.Parse(typeof(eLockTarget), option as String), data); break;
					case "G2Write": mReader.G2Write((eG2Bank)Enum.Parse(typeof(eG2Bank), option as string), ((int)nudWordPtr2.Value).ToString(), data); break;
					case "ProgramAlienImage": mReader.ProgramAlienImage(data); break;
					case "ProgAlienImageMap": mReader.ProgAlienImageMap = option; break;
					case "ProgAlienImageNSI": mReader.ProgAlienImageNSI = data; break;

					default: break;
				}
			}
			catch (Exception ex)
			{
				status = ex.Message;
			}
			if (status == null)
				status = "Ready.";

			lblStatus.Text = status;
		}

		private void protocol_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			bool supported = true;
			int p = 0;
			this.Cursor = Cursors.WaitCursor;
			RadioButton rdo = sender as RadioButton;
			if (rdo.Checked)
			{
				if (rdo.Name.EndsWith("2"))
					p = 2;
				else
					p = 1;
			}
			supported = checkProtocol(p);

			this.Cursor = Cursors.Default;

			if (!supported)
				e.Cancel = true;
		}


		private void btnG2Read_Click(object sender, System.EventArgs e)
		{
			lblG2ReadResponse.Text = "";
			if (cboG2Bank.SelectedIndex != -1)
			{
				try 
				{
					lblG2ReadResponse.Text = mReader.G2Read(
						(eG2Bank)(cboG2Bank.SelectedIndex), 
						((int)(nudWordPtr.Value)).ToString(),
						((int)(nudWordLen.Value)).ToString());

					lblStatus.Text = "Ready";
				}
				catch (Exception ex)
				{
					lblStatus.Text = ex.Message;
				}
			}
			else
			{
				lblStatus.Text = "Select the Gen2 Bank value";
				cboG2Bank.DroppedDown = true;
			}

		}
	}
}
